<section id="pricing" class="py-20 bg-[#0f172a]">
    <div class="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8">
        <h2 class="text-4xl font-bold text-center mb-16 text-white"><?php pll_e('Оберіть Свій План'); ?></h2>
        <div class="grid md:grid-cols-3 gap-8">
            <div class="bg-[#1e293b] rounded-xl p-8 shadow-lg border border-gray-700/30 hover:shadow-xl transition-shadow">
                <h3 class="text-2xl font-bold mb-4 text-white"><?php pll_e('Стандарт'); ?></h3>
                <div class="mb-6 text-white">
                    <span class="text-4xl font-bold">€49</span>
                    <span class="text-gray-400">/<?php pll_e('місяць'); ?></span>
                </div>
                <ul class="space-y-3 mb-8 text-gray-300">
                    <li class="flex items-center">
                        <div class="w-5 h-5 flex items-center justify-center mr-3">
                            <i class="ri-check-line text-green-500"></i>
                        </div>
                        <span><?php pll_e('Доступ на 1 місяць'); ?></span>
                    </li>
                    <li class="flex items-center">
                        <div class="w-5 h-5 flex items-center justify-center mr-3">
                            <i class="ri-check-line text-green-500"></i>
                        </div>
                        <span><?php pll_e('Усі базові індикатори'); ?></span>
                    </li>
                    <li class="flex items-center">
                        <div class="w-5 h-5 flex items-center justify-center mr-3">
                            <i class="ri-check-line text-green-500"></i>
                        </div>
                        <span><?php pll_e('Підтримка по email'); ?></span>
                    </li>
                    <li class="flex items-center">
                        <div class="w-5 h-5 flex items-center justify-center mr-3">
                            <i class="ri-check-line text-green-500"></i>
                        </div>
                        <span><?php pll_e('Інструкції з встановлення'); ?></span>
                    </li>
                </ul>
                <button onclick="selectPlan('Standard - €49/month')" class="w-full bg-gray-900 text-white py-3 !rounded-button font-semibold hover:bg-gray-800 transition-colors whitespace-nowrap">
                    <?php pll_e('Обрати Стандарт'); ?>
                </button>
            </div>
            <div class="bg-primary/10 backdrop-blur-sm rounded-xl p-8 shadow-lg border-2 border-primary hover:shadow-xl transition-shadow relative">
                <div class="absolute -top-4 left-1/2 transform -translate-x-1/2 bg-primary text-white px-4 py-1 rounded-full text-sm font-semibold shadow-md">
                    <?php pll_e('Найпопулярніший'); ?>
                </div>
                <h3 class="text-2xl font-bold mb-4"><?php pll_e('Про'); ?></h3>
                <div class="mb-6">
                    <span class="text-4xl font-bold">€359</span>
                    <span class="text-gray-300">/<?php pll_e('рік'); ?></span>
                </div>
                <ul class="space-y-3 mb-8 text-gray-300">
                    <li class="flex items-center">
                        <div class="w-5 h-5 flex items-center justify-center mr-3">
                            <i class="ri-check-line text-green-500"></i>
                        </div>
                        <span><?php pll_e('Доступ на 12 місяців'); ?></span>
                    </li>
                    <li class="flex items-center">
                        <div class="w-5 h-5 flex items-center justify-center mr-3">
                            <i class="ri-check-line text-green-500"></i>
                        </div>
                        <span><?php pll_e('Усі преміум індикатори'); ?></span>
                    </li>
                    <li class="flex items-center">
                        <div class="w-5 h-5 flex items-center justify-center mr-3">
                            <i class="ri-check-line text-green-500"></i>
                        </div>
                        <span><?php pll_e('Пріоритетна підтримка'); ?></span>
                    </li>
                    <li class="flex items-center">
                        <div class="w-5 h-5 flex items-center justify-center mr-3">
                            <i class="ri-check-line text-green-500"></i>
                        </div>
                        <span><?php pll_e('Відеоуроки'); ?></span>
                    </li>
                    <li class="flex items-center">
                        <div class="w-5 h-5 flex items-center justify-center mr-3">
                            <i class="ri-check-line text-green-500"></i>
                        </div>
                        <span><?php pll_e('Торгові стратегії'); ?></span>
                    </li>
                </ul>
                <button onclick="selectPlan('Pro - €359/year')" class="w-full bg-primary text-white py-3 !rounded-button font-semibold hover:bg-blue-700 transition-colors whitespace-nowrap">
                    <?php pll_e('Обрати Про'); ?>
                </button>
            </div>
            <div class="bg-[#1e293b] rounded-xl p-8 shadow-lg border border-gray-700/30 hover:shadow-xl transition-shadow">
                <h3 class="text-2xl font-bold mb-4 text-white"><?php pll_e('Назавжди'); ?></h3>
                <div class="mb-6 text-white">
                    <span class="text-4xl font-bold">€449</span>
                    <span class="text-gray-400">/<?php pll_e('назавжди'); ?></span>
                </div>
                <ul class="space-y-3 mb-8 text-gray-300">
                    <li class="flex items-center">
                        <div class="w-5 h-5 flex items-center justify-center mr-3">
                            <i class="ri-check-line text-green-500"></i>
                        </div>
                        <span><?php pll_e('Необмежений доступ'); ?></span>
                    </li>
                    <li class="flex items-center">
                        <div class="w-5 h-5 flex items-center justify-center mr-3">
                            <i class="ri-check-line text-green-500"></i>
                        </div>
                        <span><?php pll_e('Усі індикатори + майбутні оновлення'); ?></span>
                    </li>
                    <li class="flex items-center">
                        <div class="w-5 h-5 flex items-center justify-center mr-3">
                            <i class="ri-check-line text-green-500"></i>
                        </div>
                        <span><?php pll_e('Розробка користувацьких інструментів'); ?></span>
                    </li>
                    <li class="flex items-center">
                        <div class="w-5 h-5 flex items-center justify-center mr-3">
                            <i class="ri-check-line text-green-500"></i>
                        </div>
                        <span><?php pll_e('Індивідуальна консультація'); ?></span>
                    </li>
                    <li class="flex items-center">
                        <div class="w-5 h-5 flex items-center justify-center mr-3">
                            <i class="ri-check-line text-green-500"></i>
                        </div>
                        <span><?php pll_e('VIP підтримка'); ?></span>
                    </li>
                </ul>
                <button onclick="selectPlan('Lifetime - €449')" class="w-full bg-gray-900 text-white py-3 !rounded-button font-semibold hover:bg-gray-800 transition-colors whitespace-nowrap">
                    <?php pll_e('Обрати Назавжди'); ?>
                </button>
            </div>
        </div>
    </div>
</section>