<?php
    $faq_query = new WP_Query(array(
        'post_type' => 'faq',
        'posts_per_page' => -1,
        'orderby' => 'menu_order',
        'order' => 'ASC',
        'post_status' => 'publish'
    ));
?>

<?php  if ($faq_query->have_posts()): ?>
    <section id="faq" class="py-20">
        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
            <h2 class="text-4xl font-bold text-center mb-16"><?php pll_e('Поширені Запитання'); ?></h2>
            <div class="space-y-4">
                <?php while ($faq_query->have_posts()) : $faq_query->the_post();
                    $faq_id = get_the_ID();
                ?>
                    <div class="border border-gray-200 rounded-lg overflow-hidden">
                        <button class="faq-toggle w-full px-6 py-4 text-left flex items-center justify-between transition-colors duration-200" data-target="faq-<?php echo esc_attr($faq_id); ?>">
                            <span class="font-semibold"><?php the_title(); ?></span>
                            <div class="w-6 h-6 flex items-center justify-center transition-transform duration-200">
                                <i class="ri-add-line text-xl"></i>
                            </div>
                        </button>
                        <div id="faq-<?php echo esc_attr($faq_id); ?>" class="faq-answer px-6 pb-4 hidden">
                            <p class="text-gray-600"><?php echo get_the_content(); ?></p>
                        </div>
                    </div>
                <?php
                    endwhile;
                    wp_reset_postdata();
                ?>
            </div>
    </section>
<?php  endif; ?>
