<?php
/*
Template Name: Информационная страница
*/

?>

<?php get_header(); ?>

    <main class="px-6 pt-24 pb-8 ">
        <div class="max-w-7xl mx-auto mb-6">
            <div class="flex items-center space-x-2 text-sm">
                <a href="<?php echo pll_home_url(); ?>" class="text-slate-400 hover:text-white transition-colors">
                    <?php pll_e('Головна'); ?>
                </a>
                <span class="text-slate-600">/</span>
                <span class="text-slate-300"><?php the_title(); ?></span>
            </div>
        </div>
        <div class="max-w-7xl mx-auto">
            <?php while (have_posts()) : the_post(); ?>
                <article class="glass-effect rounded-xl p-6">
                    <h1 class="text-3xl font-bold text-white mb-4"><?php the_title(); ?></h1>

                    <div class="text-slate-400 space-y-6 text-justify information-page">
                        <?php the_content(); ?>
                    </div>

                </article>
            <?php endwhile; ?>
        </div>
    </main>

<?php get_footer(); ?>