<?php
/*
Template Name: Про нас
*/
?>

<?php get_header(); ?>

    <main class="px-6 pt-24 pb-8 bg-gray-900">
        <div class="max-w-7xl mx-auto mb-6">
            <div class="flex items-center space-x-2 text-sm">
                <a href="<?php echo pll_home_url(); ?>" class="text-slate-400 hover:text-white transition-colors">
                    <?php pll_e('Головна'); ?>
                </a>
                <span class="text-slate-600">/</span>
                <span class="text-slate-300"><?php pll_e('Про нас'); ?></span>
            </div>
        </div>
        <div class="max-w-7xl mx-auto">
            <?php while (have_posts()) : the_post(); ?>
                <article class="glass-effect rounded-xl p-6">
                    <h1 class="text-3xl font-bold text-white mb-4"><?php pll_e('Про нас'); ?></h1>
<!--                    <div class="text-slate-400 space-y-6 text-justify mb-6 p-4 rounded-lg">-->
<!--                        --><?php ////the_content(); ?>
<!--                    </div>-->
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-6">
                        <div class="md:col-span-1">
                            <img src="<?php echo get_template_directory_uri(); ?>/images/about-us.jpg" class="rounded-lg w-full h-auto">
                        </div>
                        <div class="md:col-span-2 text-slate-400 space-y-4">
                            <?php the_content(); ?>
                        </div>
                    </div>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div class="bg-gray-700 p-4 rounded-lg">
                            <h2 class="text-xl font-semibold text-white mb-2"><?php pll_e('Телефон'); ?></h2>
                            <p class="text-slate-400">+38(073) 505-6809</p>
                        </div>
                        <div class="bg-gray-700 p-4 rounded-lg">
                            <h2 class="text-xl font-semibold text-white mb-2"><?php pll_e('Емейл'); ?></h2>
                            <p class="text-slate-400"><a href="mailto:support@twrangers.com" target="_blank" class="text-blue-400 hover:text-blue-300">support@twrangers.com</a></p>
                        </div>
                        <div class="bg-gray-700 p-4 rounded-lg">
                            <h2 class="text-xl font-semibold text-white mb-2"><?php pll_e('Адреса'); ?></h2>
                            <p class="text-slate-400"><?php pll_e('вул. Миру 12, Покровське, Дніпропетровська область, 53600'); ?></p>
                        </div>
                        <div class="bg-gray-700 p-4 rounded-lg">
                            <h2 class="text-xl font-semibold text-white mb-2"><?php pll_e('Графік роботи'); ?></h2>
                            <p class="text-slate-400"><?php pll_e('Пн-Пт: 9:00-18:00, Сб-Нд: Вихідний'); ?></p>
                        </div>
                    </div>
                    <div class="mt-6 bg-gray-700 p-4 rounded-lg text-center">
                        <h2 class="text-xl font-semibold text-white mb-2"><?php pll_e('Інформація про ФОП'); ?></h2>
                        <p class="text-slate-400">
                            <?php pll_e('ФОП “Сиволодський Олег Станіславович”'); ?><br>
                            <?php pll_e('ЄДРПОУ: 3537400135'); ?><br>
                            <?php pll_e('IBAN: UA833052990000026006035019289'); ?>
                        </p>
                    </div>
                </article>
            <?php endwhile; ?>
        </div>
    </main>

<?php get_footer(); ?>