<?php
class Walker_Simple_Anchor extends Walker_Nav_Menu {
    private $link_class;

    public function __construct($link_class = '') {
        $this->link_class = $link_class;
    }

    function start_el( &$output, $item, $depth = 0, $args = [], $id = 0 ) {
        $output .= '<a href="' . esc_url( $item->url ) . '" class="' . esc_attr($this->link_class) . '">' . esc_html( $item->title ) . '</a>';
    }

    function end_el( &$output, $item, $depth = 0, $args = [] ) {
        // ничего не добавляем
    }
}
