<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>TheTrader - Торгові Індикатори для TradingView та ThinkOrSwim</title>
    <script src="https://cdn.tailwindcss.com/3.4.16"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: '#2563eb',
                        secondary: '#1d4ed8'
                    },
                    borderRadius: {
                        'none': '0px',
                        'sm': '4px',
                        DEFAULT: '8px',
                        'md': '12px',
                        'lg': '16px',
                        'xl': '20px',
                        '2xl': '24px',
                        '3xl': '32px',
                        'full': '9999px',
                        'button': '8px'
                    }
                }
            }
        }
    </script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Pacifico&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/remixicon/4.6.0/remixicon.min.css" rel="stylesheet">
    <?php wp_head(); ?>
</head>
<?php
    $body_classes = array();

    if (is_front_page()) {
        $body_classes[] = 'bg-[#0f172a]';
        $body_classes[] = 'text-gray-100';
    }
    elseif (is_page_template('page-login.php')) {
        $body_classes[] = 'min-h-screen';
        $body_classes[] = 'gradient-bg';
        $body_classes[] = 'text-slate-100';
    }
    elseif (is_page_template('page-cabinet.php') || is_single()) {
        $body_classes[] = 'bg-[#0F0F19]';
        $body_classes[] = 'min-h-screen';
    }
    else {
        $body_classes[] = 'bg-[#0F0F19]';
        //$body_classes[] = 'min-h-screen';
    }

    $body_classes = apply_filters('body_class', $body_classes);
    $current_user = wp_get_current_user();
    $date_end_subscribe = get_field('date_end_subscribe', 'user_' . $current_user->ID);

    $current_lang = pll_current_language();
    $current_id   = get_the_ID();

    $url_uk = '';
    $url_en = '';

    if (is_singular()) {
        $id_uk = pll_get_post($current_id, 'uk');
        $id_en = pll_get_post($current_id, 'en');
        $url_uk = $id_uk ? get_permalink($id_uk) : pll_home_url('uk');
        $url_en = $id_en ? get_permalink($id_en) : pll_home_url('en');
    } else {
        // для главной/архивов — на соответствующую домашнюю
        $url_uk = pll_home_url('uk');
        $url_en = pll_home_url('en');
    }
?>
<body <?php body_class($body_classes); ?>>
<?php if (!is_page_template('page-cabinet.php') && !is_single()): ?>
<nav class="fixed top-0 left-0 right-0 bg-[#1e293b]/95 backdrop-blur-sm border-b border-gray-800 z-50">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="flex items-center justify-between h-16">
            <div class="flex items-center">
                <div class="font-['Pacifico'] text-2xl text-primary">logo</div>
            </div>
            <div class="hidden md:flex items-center space-x-8">
                <?php
                    wp_nav_menu([
                        'theme_location' => 'main-menu',
                        'container' => false,
                        'items_wrap' => '%3$s',
                        'walker' => new Walker_Simple_Anchor('text-gray-300 hover:text-primary transition-colors'),
                    ]);
                ?>
                <?php if ( is_user_logged_in() ) : ?>
                    <a href="<?php echo pll_home_url() . 'cabinet/'; ?>" class="text-gray-300 hover:text-primary transition-colors"><?php pll_e('Кабінет'); ?></a>
                    <a href="<?php echo wp_logout_url( pll_home_url($current_lang) ); ?>" class="text-gray-300 hover:text-primary transition-colors"><?php pll_e('Вийти'); ?> (<?php echo esc_html( $current_user->display_name ); ?>)</a>
                <?php else : ?>
                    <a href="<?php echo pll_home_url() . '/login'; ?>" class="text-gray-300 hover:text-primary transition-colors"><?php pll_e('Увійти'); ?></a>
                <?php endif; ?>

                <div class="flex items-center bg-slate-700 rounded-lg p-1">
                    <a href="<?= esc_url($url_uk) ?>"
                       class="px-3 py-1 rounded text-sm font-medium transition-all duration-200 <?= $current_lang==='uk'?'bg-primary text-white':'text-slate-300 hover:text-white' ?>">
                        UA
                    </a>
                    <a href="<?= esc_url($url_en) ?>"
                       class="px-3 py-1 rounded text-sm font-medium transition-all duration-200 <?= $current_lang==='en'?'bg-primary text-white':'text-slate-300 hover:text-white' ?>">
                        EN
                    </a>
                </div>
            </div>
            <div class="md:hidden">
                <button id="mobile-menu-toggle" class="w-8 h-8 flex items-center justify-center">
                    <i class="ri-menu-line text-xl text-white"></i>
                </button>
            </div>
        </div>
    </div>
    <div id="mobile-menu" class="mobile-menu fixed top-16 right-0 w-3/4 h-[calc(100vh-64px)] bg-[#1e293b] shadow-lg md:hidden">    
        <div class="p-6 space-y-4">
            <?php
                wp_nav_menu([
                    'theme_location' => 'main-menu',
                    'container' => false,
                    'items_wrap' => '%3$s',
                    'walker' => new Walker_Simple_Anchor('block text-gray-100 hover:text-primary transition-colors')
                ]);
            ?>

            <?php if ( is_user_logged_in() ) : ?>
                <a href="<?php echo pll_home_url() . 'cabinet/'; ?>" data-readdy="true" class="block text-gray-100 hover:text-primary transition-colors"><?php pll_e('Кабінет'); ?></a>
                <a href="<?php echo wp_logout_url( pll_home_url($current_lang) ); ?>" data-readdy="true" class="block text-gray-100 hover:text-primary transition-colors"><?php pll_e('Вийти'); ?> (<?php echo esc_html( $current_user->display_name ); ?>)</a>
            <?php else: ?>
                <a href="<?php echo pll_home_url() . '/login'; ?>" data-readdy="true" class="block text-gray-100 hover:text-primary transition-colors"><?php pll_e('Увійти'); ?></a>
            <?php endif; ?>

            <div class="border-t pt-4">
                <div class="flex w-max items-center bg-slate-700 rounded-lg p-1">
                    <a href="<?= esc_url($url_uk) ?>"
                        class="px-3 py-1 rounded-lg text-sm font-medium transition-all duration-200 <?php echo $current_lang === 'uk' ? 'bg-primary text-white':'text-slate-300 hover:text-white'; ?>">
                        UA
                    </a>
                    <a href="<?= esc_url($url_en) ?>"
                    class="px-3 py-1 rounded-lg text-sm font-medium transition-all duration-200 <?= $current_lang==='en'?'bg-primary text-white':'text-slate-300 hover:text-white' ?>">
                        EN
                    </a>
                </div>
            </div>
        </div>
    </div>
</nav>
<?php else: ?>
    <?php
        $days_difference = 13;
        if ($date_end_subscribe) {
            $end_date = DateTime::createFromFormat('d.m.Y', $date_end_subscribe);
            $current_date = new DateTime();

            $interval = $current_date->diff($end_date);
            $days_difference = $interval->days;
        }
    ?>
    <header class="fixed top-0 left-0 right-0 bg-[#1A1A2E]/95 backdrop-blur-sm border-b border-gray-800 z-50">
        <div class="w-full px-6 py-4">
            <div class="flex items-center justify-between">
                <div class="flex items-center space-x-8">
                    <div class="font-['Pacifico'] text-xl text-white">logo</div>
                    <h1 class="text-xl font-semibold text-white hidden md:block">
                        <a href="<?php echo pll_home_url() . 'cabinet/'; ?>"><?php pll_e('Особистий кабінет'); ?></a>
                    </h1>
                </div>
                <div class="hidden md:flex items-center space-x-6">
                    <div class="bg-blue-900/20 px-4 py-2 rounded-lg border border-blue-800">
                        <span class="text-sm text-blue-400"><?php pll_e('Днів до закінчення підписки:'); ?> <span class="font-semibold"><?php echo $days_difference; ?></span></span>
                    </div>
                </div>
                <div class="hidden md:flex items-center space-x-6">
                    <?php if (!is_single()): ?>
                        <nav class="flex space-x-4">
                            <button data-platform="tradingview" class="px-4 py-2 text-gray-600 hover:text-white transition-colors !rounded-button whitespace-nowrap">TradingView</button>
                            <button data-platform="tos" class="px-4 py-2 text-gray-600 hover:text-white transition-colors !rounded-button whitespace-nowrap">TOС</button>
                        </nav>
                    <?php endif; ?>
                    <div class="flex items-center space-x-3">
                        <div class="relative">
                            <div class="flex items-center bg-slate-700 rounded-lg p-1">
                                <a href="<?= esc_url($url_uk) ?>"
                                   class="px-3 py-1 rounded text-sm font-medium transition-all duration-200 <?= $current_lang==='uk'?'bg-primary text-white':'text-slate-300 hover:text-white' ?>">
                                    UA
                                </a>
                                <a href="<?= esc_url($url_en) ?>"
                                   class="px-3 py-1 rounded text-sm font-medium transition-all duration-200 <?= $current_lang==='en'?'bg-primary text-white':'text-slate-300 hover:text-white' ?>">
                                    EN
                                </a>
                            </div>
                        </div>
                    </div>
                    <a id="logoutBtn" class="px-4 py-2 border border-gray-700 text-gray-300 rounded-lg hover:bg-gray-800 transition-colors !rounded-button whitespace-nowrap cursor-pointer select-none"><?php pll_e('Вихід'); ?></a>
                </div>
                <div class="md:hidden">
                    <div class="flex items-center justify-end">
                        <div class="bg-blue-900/20 px-3 py-2 rounded-lg border border-blue-800 mr-4">
                            <span class="text-sm text-blue-400"><?php pll_e('До закінчення:'); ?> <span class="font-semibold"><?php echo $days_difference; ?> д.</span></span>
                        </div>
                        <button id="mobile-menu-toggle" class="w-8 h-8 flex items-center justify-center">
                            <i class="ri-menu-line text-xl text-white"></i>
                        </button>
                    </div>
                </div>
            </div>
            <div id="mobile-menu" class="mobile-menu fixed top-16 right-0 w-3/4 h-[calc(100vh-64px)] bg-[#1e293b] shadow-lg md:hidden">
                <div class="p-6 space-y-4">
                    <a href="<?php echo pll_home_url() . 'cabinet/'; ?>" class="block text-gray-100 hover:text-primary transition-colors">
                        <?php pll_e('Особистий кабінет'); ?>
                    </a>
                    <?php if ( is_user_logged_in() ) : ?>
                        <a href="<?php echo wp_logout_url( home_url('/') ); ?>" data-readdy="true" class="block text-gray-100 hover:text-primary transition-colors">Вийти (<?php echo esc_html( $current_user->display_name ); ?>)</a>
                    <?php else: ?>
                        <a href="/login" data-readdy="true" class="block text-gray-100 hover:text-primary transition-colors">Увійти</a>
                    <?php endif; ?>
                    <?php if (!is_single()): ?>
                        <div class="border-t pt-4">
                            <nav class="flex w-max space-x-4">
                                <button data-platform="tradingview" class="px-4 py-2 text-gray-100 hover:text-white transition-colors !rounded-button whitespace-nowrap">TradingView</button>
                                <button data-platform="tos" class="px-4 py-2 text-gray-100 hover:text-white transition-colors !rounded-button whitespace-nowrap">TOС</button>
                            </nav>
                        </div>
                    <?php endif; ?>
                    <div class="border-t pt-4">
                        <div class="flex w-max items-center bg-slate-700 rounded-lg p-1">
                            <a href="<?= esc_url($url_uk) ?>"
                            class="px-3 py-1 rounded-lg text-sm font-medium transition-all duration-200 <?= $current_lang==='uk'?'bg-primary text-white':'text-slate-300 hover:text-white' ?>">
                                UA
                            </a>
                            <a href="<?= esc_url($url_en) ?>"
                            class="px-3 py-1 rounded-lg text-sm font-medium transition-all duration-200 <?= $current_lang==='en'?'bg-primary text-white':'text-slate-300 hover:text-white' ?>">
                                EN
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </header>
<?php endif; ?>
