<?php

require_once get_template_directory() . '/inc/nav-walker.php';

function the_enqueue_scripts() {
    wp_enqueue_style('the-main-style', get_template_directory_uri() . '/css/style.css');
}
add_action('wp_enqueue_scripts', 'the_enqueue_scripts');

function the_register_platform_taxonomy() {
    register_taxonomy(
        'platform',
        'post',
        array(
            'label' => 'Платформа',
            'rewrite' => array('slug' => 'platform'),
            'show_in_rest' => true,
            'hierarchical' => true,
            'show_admin_column' => true,
        )
    );
}
add_action('init', 'the_register_platform_taxonomy');

function the_theme_setup() {
    // Поддержка заголовков
    add_theme_support('title-tag');
    add_theme_support('post-thumbnails');
}
add_action('after_setup_theme', 'the_theme_setup');

function the_register_menus() {
    register_nav_menus(array(
        'main-menu' => 'Главное меню'
    ));
}
add_action('init', 'the_register_menus');

function create_member_role() {
    add_role('site_member', 'Site Member', array(
        'read' => true,
        'edit_posts' => false,
        'delete_posts' => false,
    ));
}
// Выполни один раз, потом закомментируй
// add_action('init', 'create_member_role');

function the_ajax_logout() {
    wp_logout();
    $redirect_url = home_url('/');
    wp_send_json_success(array('redirect' => $redirect_url));
}
add_action('wp_ajax_nopriv_logout', 'the_ajax_logout');
add_action('wp_ajax_logout', 'the_ajax_logout');

add_filter('wpcf7_autop_or_not', '__return_false');

function the_add_menu_order_column($columns) {
    $new_columns = array();

    foreach ($columns as $key => $value) {
        $new_columns[$key] = $value;
        if ($key === 'title') {
            $new_columns['menu_order'] = 'Порядок';
        }
    }

    return $new_columns;
}

add_filter('manage_faq_posts_columns', 'the_add_menu_order_column');

function the_display_menu_order_column($column_name, $post_id) {
    if ($column_name === 'menu_order') {
        $post = get_post($post_id);
        echo esc_html($post->menu_order);
    }
}

add_action('manage_faq_posts_custom_column', 'the_display_menu_order_column', 10, 2);

function the_sortable_menu_order_column($columns) {
    $columns['menu_order'] = 'menu_order';
    return $columns;
}

add_filter('manage_edit-faq_sortable_columns', 'the_sortable_menu_order_column');

function the_hide_admin_bar_for_site_member() {
    $current_user = wp_get_current_user();

    if (in_array('site_member', $current_user->roles)) {
        show_admin_bar(false);
    }
}
add_action('after_setup_theme', 'the_hide_admin_bar_for_site_member');

function the_add_drawio_mime_type($mimes) {
    $mimes['drawio'] = 'application/xml';  // Или 'text/xml', если нужно
    return $mimes;
}
add_filter('upload_mimes', 'the_add_drawio_mime_type');

add_filter('wp_check_filetype_and_ext', function($data, $file, $filename, $mimes) {
    $wp_filetype = wp_check_filetype($filename, $mimes);
    return [
        'ext'             => $wp_filetype['ext'],
        'type'           => $wp_filetype['type'],
        'proper_filename' => $data['proper_filename']
    ];
}, 10, 4);