<?php
    /*
        Template Name: Страница логина
    */

// Проверяем, если пользователь уже авторизован - перенаправляем
//    if (is_user_logged_in()) {
//        wp_redirect(home_url());
//        exit;
//    }

$login_error = '';

// Обработка формы
if ($_POST && isset($_POST['custom_login_nonce'])) {
    if (wp_verify_nonce($_POST['custom_login_nonce'], 'custom_login_action')) {

        $username = sanitize_user($_POST['email']);
        $password = $_POST['password'];

        // Проверяем учетные данные
        $user = wp_authenticate($username, $password);

        if (is_wp_error($user)) {
            $login_error = $user->get_error_message();
        } else {
            if (in_array('site_member', $user->roles)) {
                wp_set_auth_cookie($user->ID);
                wp_redirect(pll_home_url() . '/cabinet/');
                exit;
            } else {
                $login_error = pll__('У вас нет доступа к личному кабинету.');
            }
        }
    } else {
        $login_error = pll__('Ошибка безопасности. Попробуйте еще раз.');
    }
}

get_header();
?>
    <div id="loginPage" class="min-h-screen flex items-center justify-center p-4">
        <div class="w-full max-w-md">
            <div class="text-center mb-8">
                <a href="<?php echo pll_home_url(); ?>" data-readdy="true" class="inline-block">
                    <h1 class="text-3xl font-['Pacifico'] text-white mb-2">TwRangers.Com</h1>
                </a>
                <p class="text-slate-300"><?php pll_e('Увійдіть до вашого особистого кабінету'); ?></p>
            </div>
            <div class="glass-effect rounded-2xl p-8 shadow-2xl">
                <form id="loginForm" class="space-y-6" data-readdy-form method="post">
                    <?php if ($login_error): ?>
                        <div class="glass-effect bg-red-500/20 border border-red-500/50 rounded-lg p-4 mb-6">
                            <div class="flex items-center space-x-2">
                                <div class="w-5 h-5 flex items-center justify-center text-red-400">
                                    <i class="ri-error-warning-line"></i>
                                </div>
                                <span class="text-red-200 text-sm"><?php echo esc_html($login_error); ?></span>
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php wp_nonce_field('custom_login_action', 'custom_login_nonce'); ?>
                    <div>
                        <label class="block text-sm font-medium text-slate-200 mb-2"><?php pll_e('Електронна пошта'); ?></label>
                        <input type="email" id="email" name="email" required class="input-field w-full px-4 py-3 rounded-lg focus:outline-none transition-all duration-300" placeholder="<?php pll_e('Введіть вашу електронну пошту'); ?>">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-slate-200 mb-2"><?php pll_e('Пароль'); ?></label>
                        <div class="relative">
                            <input type="password" id="password" name="password" required class="input-field w-full px-4 py-3 rounded-lg focus:outline-none transition-all duration-300" placeholder="<?php pll_e('Введіть ваш пароль'); ?>">
                            <button type="button" id="togglePassword" class="absolute right-3 top-1/2 transform -translate-y-1/2 text-slate-400 hover:text-slate-200">
                                <div class="w-5 h-5 flex items-center justify-center">
                                    <i class="ri-eye-line"></i>
                                </div>
                            </button>
                        </div>
                    </div>
                    <div class="flex items-center">
                        <input type="checkbox" id="remember" class="hidden">
                        <label for="remember" class="flex items-center cursor-pointer">
                            <div class="w-5 h-5 border-2 border-slate-400 rounded flex items-center justify-center mr-3 transition-all duration-200" id="rememberBox">
                                <div class="w-3 h-3 bg-primary rounded opacity-0 transition-opacity duration-200" id="rememberCheck"></div>
                            </div>
                            <span class="text-sm text-slate-300"><?php pll_e('Запам`ятати мене'); ?></span>
                        </label>
                    </div>
                    <button type="submit" class="btn-primary !rounded-button w-full py-3 text-white font-semibold whitespace-nowrap">
                        <?php pll_e('Увійти'); ?>
                    </button>
                    <div class="text-center space-y-3">
                        <a href="#" class="text-primary hover:text-blue-300 text-sm transition-colors duration-200"><?php pll_e('Забули пароль?'); ?></a>
                        <p class="text-xs text-slate-400"><?php pll_e('Немає облікового запису?'); ?> <a href="<?php echo pll_home_url(); ?>#pricing" data-readdy="true" class="text-primary hover:text-blue-300"><?php pll_e('Надішліть запит на веб-сайті'); ?></a></p>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php get_footer();