// document.addEventListener('DOMContentLoaded', function() {
//     const filterButtons = document.querySelectorAll('main button');
//     filterButtons.forEach(button => {
//         button.addEventListener('click', function() {
//             filterButtons.forEach(btn => {
//                 btn.classList.remove('bg-blue-600', 'text-white', 'hover:bg-blue-700');
//                 btn.classList.add('bg-gray-800', 'text-gray-300', 'hover:bg-gray-700');
//             });
//             this.classList.remove('bg-gray-800', 'text-gray-300', 'hover:bg-gray-700');
//             this.classList.add('bg-blue-600', 'text-white', 'hover:bg-blue-700');
//         });
//     });
// });

document.addEventListener('DOMContentLoaded', function() {
    const filterButtons = document.querySelectorAll('main button');

    // читаем фильтр из URL
    const urlParams = new URLSearchParams(window.location.search);
    const activeFilter = urlParams.get('filter') || 'all';

    // ставим активный класс
    filterButtons.forEach(button => {
        if (button.dataset.filter === activeFilter) {
            button.classList.add('bg-blue-600', 'text-white', 'hover:bg-blue-700');
        } else {
            button.classList.add('bg-gray-800', 'text-gray-300', 'hover:bg-gray-700');
        }
    });

    // обработчик клика
    filterButtons.forEach(button => {
        button.addEventListener('click', function() {
            const filter = this.dataset.filter;

            // если клик по активной кнопке → ничего не делаем
            if (filter === activeFilter) return;

            let url = new URL(window.location.href);

            if (filter === 'all') {
                // убираем параметр
                url.searchParams.delete('filter');
            } else {
                // ставим параметр
                url.searchParams.set('filter', filter);
            }

            window.location.href = url.toString();
        });
    });
});


document.addEventListener('DOMContentLoaded', function() {
    const cards = document.querySelectorAll('.grid > div');
    cards.forEach(card => {
        card.addEventListener('mouseenter', function() {
            this.style.transform = 'translateY(-2px)';
        });
        card.addEventListener('mouseleave', function() {
            this.style.transform = 'translateY(0)';
        });
    });
});

// document.addEventListener('DOMContentLoaded', function() {
//     const navButtons = document.querySelectorAll('nav button');
//     navButtons.forEach(button => {
//         button.addEventListener('click', function() {
//             navButtons.forEach(btn => {
//                 btn.classList.remove('bg-primary', 'text-white');
//                 btn.classList.add('text-gray-600');
//             });
//             this.classList.remove('text-gray-600');
//             this.classList.add('bg-primary', 'text-white');
//         });
//     });
// });

document.addEventListener('DOMContentLoaded', function() {
    const navButtons = document.querySelectorAll('nav button');

    // Читаем куку
    const selectedPlatform = document.cookie.replace(/(?:(?:^|.*;\s*)platform\s*\=\s*([^;]*).*$)|^.*$/, "$1") || 'tradingview';

    // Подсвечиваем выбранную кнопку
    navButtons.forEach(button => {
        if (button.dataset.platform === selectedPlatform) {
            button.classList.add('bg-primary', 'text-white');
            button.classList.remove('text-gray-600');
        } else {
            button.classList.remove('bg-primary', 'text-white');
            button.classList.add('text-gray-600');
        }
    });

    // Клик по кнопке
    navButtons.forEach(button => {
        button.addEventListener('click', function() {
            const platform = this.dataset.platform;

            // Сохраняем куку на 7 дней
            document.cookie = `platform=${platform}; path=/; max-age=${7*24*60*60}`;

            // Меняем активный класс
            navButtons.forEach(btn => {
                btn.classList.remove('bg-primary', 'text-white');
                btn.classList.add('text-gray-600');
            });
            this.classList.add('bg-primary', 'text-white');
            this.classList.remove('text-gray-600');

            // Перезагружаем страницу
            window.location.reload();
        });
    });
});
