<footer class="bg-[#0f172a] text-white py-12 border-t border-gray-800">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid md:grid-cols-4 gap-8">
            <div>
                <div class="font-['Pacifico'] text-2xl text-primary mb-4">logo</div>
                <p class="text-gray-400 text-sm leading-relaxed">
                    <?php pll_e('Професійні торгові індикатори для TradingView та ThinkOrSwim.'); ?>
                    <?php pll_e('Не пов`язано з Charles Schwab & Co., Inc.'); ?>
                </p>
            </div>
            <div>
                <h3 class="font-semibold mb-4"><?php pll_e('Контакти'); ?></h3>
                <div class="space-y-2 text-sm">
                    <div class="flex items-center">
                        <div class="w-5 h-5 flex items-center justify-center mr-3">
                            <i class="ri-mail-line"></i>
                        </div>
                        <a href="mailto:support@twrangers.com" class="text-gray-400 hover:text-white transition duration-200">
                            support@twrangers.com
                        </a>
                    </div>
                    <div class="flex items-center">
                        <div class="w-5 h-5 flex items-center justify-center mr-3">
                            <i class="ri-telegram-line"></i>
                        </div>
                        <a target="_blank" href="https://t.me/thinkorswimru_view" class="text-gray-400 hover:text-white transition duration-200">
                            @thinkorswimru_view
                        </a>
                    </div>
                </div>
            </div>
            <div>
                <h3 class="font-semibold mb-4"><?php pll_e('Информація'); ?></h3>
                <div class="space-y-2 text-sm">
                    <a href="<?php echo pll_home_url() . 'about-us/'; ?>" class="block text-gray-400 hover:text-white transition-colors"><?php pll_e('Про нас'); ?></a>
                    <a href="<?php echo pll_home_url() . 'privacy-policy/'; ?>" class="block text-gray-400 hover:text-white transition-colors"><?php pll_e('Політика конфіденційності'); ?></a>
                    <a href="<?php echo pll_home_url() . 'terms-of-service/'; ?>" class="block text-gray-400 hover:text-white transition-colors"><?php pll_e('Умови надання послуг'); ?></a>
                </div>
            </div>
            <div>
                <h3 class="font-semibold mb-4"><?php pll_e('Платіжні системи'); ?></h3>
                <div class="flex gap-4">
                    <img src="<?php echo get_template_directory_uri(); ?>/images/visa.svg" class="h-14">
                    <img src="<?php echo get_template_directory_uri(); ?>/images/mastercard.svg" class="h-14">
                </div>
            </div>
        </div>
        <div class="border-t border-gray-800 mt-8 pt-8 text-center text-sm text-gray-400">
            <p>&copy; <?php echo date('Y'); ?> TW Rangers. All rights reserved.</p>
        </div>
    </div>
</footer>
<div id="access-modal" class="fixed inset-0 bg-black/80 hidden items-center justify-center z-50">
    <div class="bg-[#1e293b] rounded-xl p-8 max-w-md w-full mx-4">
        <div class="flex items-center justify-between mb-6">
            <h3 class="text-2xl font-bold"><?php pll_e('Отримати доступ'); ?></h3>
            <button onclick="closeAccessForm()" class="w-8 h-8 flex items-center justify-center">
                <i class="ri-close-line text-xl"></i>
            </button>
        </div>
        <?php
            $current_language = pll_current_language();
            if ($current_language == 'uk') {
                echo do_shortcode('[contact-form-7 id="401a04b" title="Request Access UA"]');
            }
            else {
                echo do_shortcode('[contact-form-7 id="de333ff" title="Request Access_EN"]');
            }
        ?>
    </div>
</div>
<script src="<?= get_stylesheet_directory_uri(); ?>/js/main.js"></script>
<?php  if (is_page_template('page-login.php')): ?>
    <script src="<?= get_stylesheet_directory_uri(); ?>/js/login.js"></script>
<?php elseif (is_page_template('page-cabinet.php')): ?>
    <script src="<?= get_stylesheet_directory_uri(); ?>/js/cabinet.js"></script>
<?php endif; ?>
<?php wp_footer(); ?>
</body>
</html>